/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE SYNCHRONOUS BCD DECADE UP/DOWN  COUNTER 
TRUTHTABLE     : 
+--------------------------------+-----------------------+
|             INPUT              |                       |
+--------------------------------+       OPERATION       |
|   LOAD_  CTEN_     D_U_  CLK   |                       |
+--------------------------------+-----------------------+
|                                |                       |
|   L        X        X     X    |   Load Parrallel Data |
|                            _   |                       |
|   H        L        L    _/    |   Decade Count Up     |
|                            _   |                       |
|   H        L        H    _/    |   Decade Count Down   |
|                                |                       |
|   H        H        X     X    |   Inhibit Counting    |
+--------------------------------+-----------------------+

   Note : 1. RC0_ goes low at the terminal count for duration
             equal to half clock pulse.
          2. MX_MN goes high for one clock duration at the
             terminal count.
             
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a190 (b, qb, qa, ctenn, dnup, qc, qd, d, c, ldn, maxmin, rcon, clk, a);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		ldn,
		dnup,
		ctenn,
		clk,
		a,
		b,
		c,
		d;
	output
		qa,
		qb,
		qc,
		qd,
		maxmin,
		rcon;
    reg
        NOTIFY_REG;
    not
	N1 (pl, ldn);
    nor
	N2 (en1, pl, ctenn);
    not  
	M190N_inst_I1 (m190n_inst_wi1, clk);
    not  
	M190N_inst_I2 (m190n_inst_wi2, dnup);
    not  
	M190N_inst_I4 (m190n_inst_wi4, ctenn);
    not  
	M190N_inst_I5 (m190n_inst_wi5, ldn);
    nor
	M190N_inst_N1 (m190n_inst_wn1, dnup, ctenn);
    nor
	M190N_inst_N2 (m190n_inst_wn2, ctenn, m190n_inst_wi2);
    nand  
	M190N_inst_NA1 (rcon, m190n_inst_wi1, m190n_inst_wi4, m190n_inst_max_minint);
    nand  
	M190N_inst_NA2 (m190n_inst_wna2, m190n_inst_wna3, m190n_inst_wi5);
    nand  
	M190N_inst_NA3 (m190n_inst_wna3, a, m190n_inst_wi5);
    nand  
	M190N_inst_NA4 (m190n_inst_wna4, b, m190n_inst_wi5);
    nand
	M190N_inst_NA5 (m190n_inst_wna5, m190n_inst_qbbint, m190n_inst_qcbint, m190n_inst_qdbint);
    nand
	M190N_inst_NA6 (m190n_inst_wna6, m190n_inst_wna4, m190n_inst_wi5);
    nand  
	M190N_inst_NA7 (m190n_inst_wna7, c, m190n_inst_wi5);
    nand
	M190N_inst_NA8 (m190n_inst_wna8, m190n_inst_wna7, m190n_inst_wi5);
    nand  
	M190N_inst_NA9 (m190n_inst_wna9, d, m190n_inst_wi5);
    nand
	M190N_inst_NA10 (m190n_inst_wna10, m190n_inst_wna9, m190n_inst_wi5);
    or
	M190N_inst_O4 (m190n_inst_wo4, m190n_inst_wa7, m190n_inst_wa8, m190n_inst_wa9);
    and  
	M190N_inst_A2 (m190n_inst_wa2, dd_net_60, m190n_inst_qabint, m190n_inst_qbbint);
    and
	M190N_inst_A5 (m190n_inst_wa5, m190n_inst_wna5, m190n_inst_wn2);
    and
	M190N_inst_A7 (m190n_inst_wa7, m190n_inst_wn2, m190n_inst_qabint, m190n_inst_qbbint, m190n_inst_qcbint);
    and
	M190N_inst_A8 (m190n_inst_wa8, m190n_inst_qaint, m190n_inst_qdint, m190n_inst_wn1);
    and
	M190N_inst_A9 (m190n_inst_wa9, m190n_inst_qaint, m190n_inst_qbint, m190n_inst_qcint, m190n_inst_wn1);
    buf  
	  (qa, m190n_inst_qaint);
    buf  
	  (qb, m190n_inst_qbint);
    buf  
	  (qc, m190n_inst_qcint);
    buf  
	  (qd, m190n_inst_qdint);
    buf  
	  (maxmin, m190n_inst_max_minint);
    not
	  (m190n_inst_qabint, m190n_inst_qaint);
    not
	  (m190n_inst_qbbint, m190n_inst_qbint);
    not
	  (m190n_inst_qcbint, m190n_inst_qcint);
    not
	  (m190n_inst_qdbint, m190n_inst_qdint);
    U_AO_3_3  
	M190N_inst_INST1_inst1 (m190n_inst_max_minint, m190n_inst_wi2, m190n_inst_qaint, m190n_inst_qdint, m190n_inst_wa2, m190n_inst_qcbint, m190n_inst_qdbint);
    U_AO_3_3
	M190N_inst_INST2_inst1 (m190n_inst_wo2, m190n_inst_wn2, m190n_inst_qabint, m190n_inst_wna5, m190n_inst_qaint, m190n_inst_qdbint, m190n_inst_wn1);
    U_AO_3_3
	M190N_inst_INST3_inst1 (m190n_inst_wo3, m190n_inst_wa5, m190n_inst_qabint, m190n_inst_qbbint, m190n_inst_qaint, m190n_inst_qbint, m190n_inst_wn1);
    U_FJK_P_RB_SB_NO  
	M190N_inst_FF1_inst1 (m190n_inst_qaint, m190n_inst_wi4, m190n_inst_wi4, clk, m190n_inst_wna2, m190n_inst_wna3, NOTIFY_REG);
    U_FJK_P_RB_SB_NO  
	M190N_inst_FF2_inst1 (m190n_inst_qbint, m190n_inst_wo2, m190n_inst_wo2, clk, m190n_inst_wna6, m190n_inst_wna4, NOTIFY_REG);
    U_FJK_P_RB_SB_NO  
	M190N_inst_FF3_inst1 (m190n_inst_qcint, m190n_inst_wo3, m190n_inst_wo3, clk, m190n_inst_wna8, m190n_inst_wna7, NOTIFY_REG);
    U_FJK_P_RB_SB_NO  
	M190N_inst_FF4_inst1 (m190n_inst_qdint, m190n_inst_wo4, m190n_inst_wo4, clk, m190n_inst_wna10, m190n_inst_wna9, NOTIFY_REG);
    buf  
	  (dd_net_60, dnup);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
